#include <iostream>
#include <iomanip>
#include "material.h"

using namespace std;


static const int bishopdiag[64] = {
    3	,	1	,	0	,	-2	,	-2	,	0	,	1	,	3	,
1	,	3	,	1	,	0	,	0	,	1	,	3	,	1	,
0	,	1	,	3	,	1	,	1	,	3	,	1	,	0	,
-2	,	0	,	1	,	3	,	3	,	1	,	0	,	-2	,
-2	,	0	,	1	,	3	,	3	,	1	,	0	,	-2	,
0	,	1	,	3	,	1	,	1	,	3	,	1	,	0	,
1	,	3	,	1	,	0	,	0	,	1	,	3	,	1	,
3	,	1	,	0	,	-2	,	-2	,	0	,	1	,	3
};

static const int center[64] = {
    -8	,	-6	,	-4	,	0	,	0	,	-4	,	-6	,	-8	,
-6	,	-4	,	-2	,	2	,	2	,	-2	,	-4	,	-6	,
-4	,	-2	,	0	,	4	,	4	,	0	,	-2	,	-4	,
0	,	2	,	4	,	8	,	8	,	4	,	2	,	0	,
0	,	2	,	4	,	8	,	8	,	4	,	2	,	0	,
-4	,	-2	,	0	,	4	,	4	,	0	,	-2	,	-4	,
-6	,	-4	,	-2	,	2	,	2	,	-2	,	-4	,	-6	,
-8	,	-6	,	-4	,	0	,	0	,	-4	,	-6	,	-8
};

static const int shelter[64] = {
    2	,	3	,	3	,	-1	,	-1	,	-1	,	4	,	2	,
-2	,	-1	,	-1	,	-5	,	-5	,	-5	,	0	,	-2	,
-5	,	-4	,	-4	,	-8	,	-8	,	-8	,	-3	,	-5	,
-8	,	-8	,	-8	,	-8	,	-8	,	-8	,	-8	,	-8	,
-7	,	-7	,	-7	,	-8	,	-8	,	-8	,	-7	,	-7	,
-6	,	-6	,	-6	,	-8	,	-8	,	-8	,	-6	,	-6	,
-5	,	-5	,	-5	,	-8	,	-8	,	-8	,	-5	,	-5	,
-4	,	-4	,	-4	,	-8	,	-8	,	-8	,	-4	,	-4	,

};
static const int pawnfile[8] = { -2, -1, 0, 1, 1, 0, -1, -2};
static const int pawnrank[8] = { -4, -2, 0, 2, 4, 6, 8, 10};
static const int pawnweight = 12;
static const int pawncenter = 48;
static const int pawnoffcenter = 32;
static const int pawnundeveloped = -32;

static const int knightcenter[8] = { -4, -2, 0, 2, 2, 0, -2, -4};
static const int knightrank[8] = { -3, -1, 0, 1, 2, 3, 3, 1};
static const int knightweight = 12;
static const int knightcorner = -128;

static const int bishopcenter[8] = { -2, -1, 0, 1, 1, 0, -1, -2};
static const int bishopweight = 4;
static const int bishopdiagonal = 12;

static const int rookfile[8] = { -2, -1, 0, 1, 1, 0, -1, -2};
static const int rookweight = 8;


static const int queenfile[8] = { -2, -1, 0, 1, 1, 0, -1, -2};
static const int queenweight = 8;

static const int kingweight = 12;


void cMaterial::init_psqt()
{


	uint pce,ph,e,i,sq,oppsq,fi,ra;

	for(pce = 0; pce < numpieces; ++pce)
		for(ph = 0; ph < 2; ++ph)
			for(e = 0; e < BRDSQ; ++e)
				psqt[pce][ph][e] = 0;

	for(pce = pwP; pce < numpieces; pce+=2)
	{
      ASS(whitepce(pce));
		for(i = 0; i < 64; ++i)
		{
              sq = sqfrom64(i);
              fi = files[sq];
              ra = ranks[sq];
              ASS(ra>=RANK1&&ra<=RANK8);
              ASS(fi>=FILEA&&fi<=FILEH);
              ASS(onbrd(sq));
              switch(pce)
              {
                case pwP:
                psqt[pce][0][sq] = pawnfile[fi]*pawnweight;
                psqt[pce][1][sq] = pawnfile[fi]*pawnweight;
                psqt[pce][1][sq] += pawnrank[ra]*pawnweight;
                break;
                case pwN:
                psqt[pce][0][sq] = knightcenter[fi]*knightweight+knightcenter[ra]*knightweight;
                psqt[pce][1][sq] = knightcenter[fi]*knightweight+knightcenter[ra]*knightweight;
                psqt[pce][0][sq] += knightrank[ra]*knightweight;
				break;
                case pwB:
                psqt[pce][0][sq] = bishopcenter[fi]*bishopweight+bishopcenter[ra]*bishopweight;
                psqt[pce][1][sq] = bishopcenter[fi]*bishopweight+bishopcenter[ra]*bishopweight;
                psqt[pce][0][sq] += bishopdiag[i]*bishopdiagonal;
                psqt[pce][1][sq] += bishopdiag[i]*bishopdiagonal;
                break;
                case pwR:
				psqt[pce][0][sq] = rookfile[fi]*rookweight;
				break;
                case pwQ:
				psqt[pce][1][sq] = queenfile[fi]*queenweight+queenfile[ra]*queenweight;
				break;
                case pwK:
                psqt[pce][1][sq] = center[i]*kingweight;
                psqt[pce][0][sq] = shelter[i]*kingweight;
				break;
                default: break;
			  }
          }
    }


       psqt[pwP][0][E4] += pawncenter;
       psqt[pwP][0][D4] += pawncenter;
       psqt[pwP][0][E5] += pawnoffcenter;
       psqt[pwP][0][D4] += pawnoffcenter;
       psqt[pwP][0][E3] += pawnoffcenter;
       psqt[pwP][0][D3] += pawnoffcenter;
       psqt[pwP][0][E2] += pawnundeveloped;
       psqt[pwP][0][D2] += pawnundeveloped;
       psqt[pwN][0][A8] += knightcorner;
       psqt[pwN][1][A8] += knightcorner;
       psqt[pwN][0][H8] += knightcorner;
       psqt[pwN][1][H8] += knightcorner;
       psqt[pwN][0][A1] += knightcorner;
       psqt[pwN][1][A1] += knightcorner;
       psqt[pwN][0][H1] += knightcorner;
       psqt[pwN][1][H1] += knightcorner;

  //fill black tables
  for(i = 0; i < 64; ++i)
  {
    sq = sqfrom64(i);
    oppsq = sqrev[sq];
    ASS(onbrd(oppsq));
    ASS(onbrd(sq));
    for(pce = pbP; pce < numpieces; pce+=2)
	{
      ASS(blackpce(pce));
      {
         ASS(whitepce(pce-1));
         psqt[pce][0][oppsq] = psqt[pce-1][0][sq];
         psqt[pce][1][oppsq] = psqt[pce-1][1][sq];
      }
    }
  }
/*
#ifdef DEBUG
cout<<"\n\n"; uint f = 0;
    int  r = 0;
   // uint sq;


for(pce = 0; pce < numpieces; ++pce)
{
        cout<<endl;
        cout<<"\n piece sq opening "<<piecechar(pce)<<endl;
    for( r = 7; r>=0; r--)
    {
        for( f = 0; f<=7; ++f)
        {
           sq = fr2sq(f,r);
           ASS(onbrd(sq));
           cout<<setw(5)<<psqt[pce][0][sq];
        }
        cout<<endl;
    }
}


for(pce = 0; pce < numpieces; ++pce)
{
        cout<<endl;
        cout<<"\n piece end "<<piecechar(pce)<<endl;
    for( r = 7; r>=0; r--)
    {
        for( f = 0; f<=7; ++f)
        {
           sq = fr2sq(f,r);
           ASS(onbrd(sq));
           cout<<setw(5)<<psqt[pce][1][sq];
        }
        cout<<endl;
    }
}
#endif
*/
}

void cMaterial::movepsqt(uint pce, uint from, uint to)
{
     ASS(onbrd(from));
     ASS(onbrd(to));
     ASS(piecegood(pce));

     uint colour = pcecolour(pce);

     ASS(colour==cW || colour==cB);
     psqvalope[colour] += (psqt[pce][OPE][to]-psqt[pce][OPE][from]);
     psqvalend[colour] += (psqt[pce][END][to]-psqt[pce][END][from]);
}

void cMaterial::addpsqt(uint pce, uint sq)
{
     ASS(onbrd(sq));
     ASS(piecegood(pce));

     uint colour = pcecolour(pce);

     ASS(colour==cW || colour==cB);
     psqvalope[colour] += psqt[pce][OPE][sq];
     psqvalend[colour] += psqt[pce][END][sq];;
}

void cMaterial::removepsqt(uint pce, uint sq)
{
     ASS(onbrd(sq));
     ASS(piecegood(pce));

     uint colour = pcecolour(pce);

     ASS(colour==cW || colour==cB);
     psqvalope[colour] -= psqt[pce][OPE][sq];
     psqvalend[colour] -= psqt[pce][END][sq];
}

//need to predefine statics in a class..... easier way to do this?
int cMaterial::psqt[numpieces][2][BRDSQ] = {
    {
       {
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       },
       {
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       }
    },
    {
       {
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       },
       {
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       }
    },
    {
       {
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       },
       {
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       }
    },
    {
       {
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       },
       {
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       }
    },
    {
       {
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       },
       {
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       }
    },
    {
       {
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       },
       {
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       }
    },
    {
       {
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       },
       {
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       }
    },
    {
       {
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       },
       {
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       }
    },
    {
       {
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       },
       {
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       }
    },
    {
       {
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       },
       {
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       }
    },
    {
       {
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       },
       {
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       }
    },
    {
       {
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       },
       {
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       }
    },
    {
       {
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       },
       {
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
       }
    }
};
